%======================================================================
% Identification
%======================================================================
\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{thesis}[1999/02/25]
%
%======================================================================
% Initial Code
%======================================================================
%
%======================================================================
% Declaration of options
%======================================================================
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{book}}
%
%======================================================================
% Execution of Options
%======================================================================
\ProcessOptions
%
%======================================================================
% Package Loading
%======================================================================
\LoadClass[11pt,a4paper,titlepage]{book}
%\RequirePackage{fancyheadings}
%\RequirePackage{chicago}
%
%%======================================================================
%% Main Code
%%======================================================================
%%
%% new counter
%%
%\newcounter{lastpart}
%%
%%
%%here we change the a4paper's definitions of the dimensions of the text 
%\normalsize
%\addtolength\textheight{-4\baselineskip}
%\addtolength\textwidth{0.5cm}
%%
%% Redefinitions of chapter, sections, ....
%%
%\renewcommand\chapter{ %\if@openright\cleardoublepage\else\clearpage\fi
%                    \clearpage
%                    \thispagestyle{plain}%
%                    \global\@topnum\z@
%                    \@afterindentfalse
%                    \secdef\@chapter\@schapter}
%\def\@chapter[#1]#2{\setcounter{lastpart}{\arabic{part}}
%                    \ifnum \c@secnumdepth >\m@ne
%                       \if@mainmatter
%                         \refstepcounter{chapter}%
%                         \typeout{\@chapapp\space\thechapter.}%
%                         \addcontentsline{toc}{chapter}%
%                                   {\protect\numberline{\thechapter}#1}%
%                       \else
%                         \addcontentsline{toc}{chapter}{#1}%
%                       \fi
%                    \else
%                      \addcontentsline{toc}{chapter}{#1}%
%                    \fi
%                    \chaptermark{#1}%
%                    \addtocontents{lof}{\protect\addvspace{10\p@}}%
%                    \addtocontents{lot}{\protect\addvspace{10\p@}}%
%                    \if@twocolumn
%                      \@topnewpage[\@makechapterhead{#2}]%
%                    \else
%                      \@makechapterhead{#2}%
%                      \@afterheading
%                    \fi}
%%
%\def\@makechapterhead#1{%
%  \vspace*{50\p@}%
%  {\parindent \z@ \centering \normalfont %\raggedright \normalfont
%    \ifnum \c@secnumdepth >\m@ne
%      \if@mainmatter
%        \large\bfseries \thechapter %\@chapapp\space \thechapter
%        \par\nobreak
%        \vskip 20\p@
%      \fi
%    \fi
%    \interlinepenalty\@M
%    \Large \bfseries #1\par\nobreak
%    \vskip 40\p@
%  }}
%%
%%
%\def\@schapter#1{\addtocounter{lastpart}{1}
%                 \markboth{#1}{#1}
%                 \addcontentsline{toc}{chapter}{#1} %\numberline{}#1}
%                 \if@twocolumn
%                   \@topnewpage[\@makeschapterhead{#1}]%
%                 \else
%                   \@makeschapterhead{#1}%
%                   \@afterheading
%                 \fi}
%%
%\def\@makeschapterhead#1{%
%  \vspace*{50\p@}%
%  {\parindent \z@ \centering %\raggedright
%    \normalfont
%    \interlinepenalty\@M
%    \Large \bfseries  #1\par\nobreak
%    \vskip 40\p@
%  }}
%%
%\renewcommand\section{\@startsection{section}{1}{\z@}%
%                                  {-3.5ex \@plus -1ex \@minus -.2ex}%
%                                  {2.3ex \@plus.2ex}%
%                                  {\centering\normalfont\normalsize\bfseries}}
%\renewcommand\subsection{\@startsection{subsection}{2}{\z@}%
%                                       {-3.25ex\@plus -1ex \@minus -.2ex}%
%                                       {1.5ex \@plus .2ex}%
%                                       {\normalfont\normalsize\bfseries}}
%%
%\renewcommand*\l@part[2]{%
%  \ifnum \c@tocdepth >-2\relax
%    \addpenalty{-\@highpenalty}%
%    \addvspace{2.25em \@plus\p@}%
%    \begingroup
%      \setlength\@tempdima{3em}%
%      \parindent \z@ \rightskip \@pnumwidth
%      \parfillskip -\@pnumwidth
%      {\leavevmode
%       \large \scshape #1\hfil \hb@xt@\@pnumwidth{\hss #2}}\par
%       \nobreak
%         \global\@nobreaktrue
%         \everypar{\global\@nobreakfalse\everypar{}}%
%    \endgroup
%  \fi}
%\renewcommand*\l@chapter[2]{%
%  \ifnum \c@tocdepth >\m@ne
%    \addpenalty{-\@highpenalty}%
%    \vskip 1.0em \@plus\p@
%    \setlength\@tempdima{1.5em}%
%    \begingroup
%      \parindent \z@ \rightskip \@pnumwidth
%      \parfillskip -\@pnumwidth
%      \leavevmode \bfseries
%      \advance\leftskip\@tempdima
%      \hskip -\leftskip
%      #1\nobreak\hfil \nobreak\hb@xt@\@pnumwidth{\hss #2}\par
%      \penalty\@highpenalty
%    \endgroup
%  \fi}
%
%\renewcommand\tableofcontents{%
%    \if@twocolumn
%      \@restonecoltrue\onecolumn
%    \else
%      \@restonecolfalse
%    \fi
%    \chapter*{\contentsname
%           %\@mkboth{%
%           %\MakeUppercase\contentsname}{\MakeUppercase\contentsname}
%             }%
%    \@starttoc{toc}%
%    \if@restonecol\twocolumn\fi
%    }
%%
%%\renewenvironment{thebibliography}[1]
%%     {\chapter*{\bibname
%%        %\@mkboth{\MakeUppercase\bibname}{\MakeUppercase\bibname}
%%       }%
%%      \list{\@biblabel{\@arabic\c@enumiv}}%
%%           {\settowidth\labelwidth{\@biblabel{#1}}%
%%            \leftmargin\labelwidth
%%            \advance\leftmargin\labelsep
%%            \@openbib@code
%%            \usecounter{enumiv}%
%%            \let\p@enumiv\@empty
%%            \renewcommand\theenumiv{\@arabic\c@enumiv}}%
%%      \sloppy
%%      \clubpenalty4000
%%      \@clubpenalty \clubpenalty
%%      \widowpenalty4000%
%%      \sfcode`\.\@m}
%%     {\def\@noitemerr
%%       {\@latex@warning{Empty `thebibliography' environment}}%
%%      \endlist}
%%
%\@ifundefined{chapter}%
% {\def\thebibliography#1{\section*{\refname
%      %\@mkboth{\uppercase{\refname}}{\uppercase{\refname}}
%   }\list
%   {[\arabic{enumi}]}{\settowidth\labelwidth{[#1]}
%   \leftmargin\labelwidth
%   \advance\leftmargin\labelsep
%   \advance\leftmargin\bibindent
%   \itemindent -\bibindent
%   \listparindent \itemindent
%   \parsep \z@
%   \usecounter{enumi}}
%   \def\newblock{}
%   \sloppy
%   \sfcode`\.=1000\relax}}
% {\def\thebibliography#1{\chapter*{\refname
%      %\@mkboth{\uppercase{\refname}}{\uppercase{\refname}}
%   }\list
%   {[\arabic{enumi}]}{\settowidth\labelwidth{[#1]}
%   \leftmargin\labelwidth
%   \advance\leftmargin\labelsep
%   \advance\leftmargin\bibindent
%   \itemindent -\bibindent
%   \listparindent \itemindent
%   \parsep \z@
%   \usecounter{enumi}}
%   \def\newblock{}
%   \sloppy
%   \sfcode`\.=1000\relax}}
%%
%% headings stuff
%%
%\pagestyle{fancyplain}
%%\headrulewidth 0pt
%%\addtolength{\headwidth}{\marginparsep}
%%\addtolength{\headwidth}{0.4\marginparwidth}
%\renewcommand{\chaptermark}[1]{\markboth{#1}{}}
%\renewcommand{\sectionmark}[1]{\markright{#1}}
%%
%\newcommand{\iznumero}{
%\ifnum\arabic{lastpart}=\arabic{part}
%  \ifnum\arabic{section}>0 
%    [\thesection
%  \else
%    [\thechapter
%  \fi
%\else
%  \ifnum\arabic{lastpart}<\arabic{part}
%    \ifnum\arabic{part}>0 
%      [\thepart
%    \fi
%  \fi
%\fi}
%%
%\newcommand{\denumero}{
%\ifnum\arabic{lastpart}=\arabic{part}
%  \ifnum\arabic{section}>0 
%    \thesection]
%  \else
%    \thechapter]
%  \fi
%\else
%  \ifnum\arabic{lastpart}<\arabic{part}
%    \ifnum\arabic{part}>0 
%      \thepart]
%    \fi
%  \fi
%\fi}
%%
%\lhead[\fancyplain{}{\bfseries\thepage}]
%      {\fancyplain{}{\denumero}}
%\chead[\fancyplain{}{\sl\leftmark}]
%      {\fancyplain{}{\sl\rightmark}}
%\rhead[\fancyplain{}{\iznumero}]
%      {\fancyplain{}{\bfseries\thepage}}
%\lfoot{}
%\cfoot{}
%\rfoot{}
%%
%%
%% captions stuff
%%
%\long\def\@makecaption#1#2{%
%  \vskip\abovecaptionskip
%  \sbox\@tempboxa{\footnotesize #1: #2}%
%  \ifdim \wd\@tempboxa >\hsize
%    {\renewcommand{\baselinestretch}{1} \footnotesize #1: #2\par}
%  \else
%    \global \@minipagefalse
%    \hb@xt@\hsize{\hfil\box\@tempboxa\hfil}%
%  \fi
%  \vskip\belowcaptionskip}
%%
%\setcounter{lastpart}{-1000}
%
%
%
%
% title page
%
%
\def\de{D\kern -.60em\raise .35ex\hbox {-}\hskip .50em}
\def\dept#1{\gdef\@dept{#1}}
\def\@title{}
\def\@author{}
\def\@dept{Departamento de Astrof\'\i sica}
\def\@submitdate{\ifcase\the\month\or
  enero\or febrero\or marzo\or abril\or mayo\or junio\or
  julio\or agosto\or septiembre\or octubre\or noviembre\or diciembre\fi
  \space de\space \number\the\year}

\def\tituloiac{%
	{\renewcommand{\baselinestretch}{1.5}
	\normalsize
	\thispagestyle{empty}%
	\begin{center}
		{DEPARTAMENTO DE ASTROFISICA\\\ \\Universidad de La Laguna}
	\end{center}
	\vfill
	\begin{center}
		{\Large\bf\uppercase\expandafter{\@title}}
	\end{center}
	\vfill
	\begin{center}
		\rm Memoria que presenta\\
		D. \@author\\
                para optar al grado de\\
		Doctor en Ciencias F\'\i sicas.
	\end{center}
	\vfill
	\begin{center}
		INSTITUTO \de\ ASTROFISICA \de\ CANARIAS\\
		\@submitdate\\
	\end{center}
	\newpage
       	\renewcommand{\baselinestretch}{1}}
        }%

\def\titulobonito{%
	\thispagestyle{empty}%
	\large
	\begin{center}
		{DEPARTAMENTO DE ASTROFISICA\\\ \\Universidad de La Laguna}
	\end{center}
	\vfill
	\begin{center}
		{\LARGE\slshape\@title\par}
	\end{center}
	\vfill
	\begin{center}
		{\Large Memoria que presenta\\
		D. \@author\\
                para optar al grado de\\
		Doctor en Ciencias F\'\i sicas.\\}
	\end{center}
	\vfill

\begin{center}
\includegraphics[width=3.5truecm,height=2.5truecm]{iac.ps}
\end{center}	
	\begin{center}
		{INSTITUTO \de\ ASTROFISICA \de\ CANARIAS\\
		\@submitdate\\}
	\end{center}	
	\newpage\normalsize}

